# StackGen CLI

A command-line interface for managing IaC generation using StackGen.

## Overview

StackGen CLI is a powerful tool for managing infrastructure as code (IaC) generation. It provides commands to create, manage, and deploy infrastructure stacks across multiple cloud providers.

## Installation

Build from source:

```bash
git clone https://github.com/appcd-dev/stackgen-cli.git
cd stackgen-cli
go build -o stackgen .
```

## Usage

### Basic Commands

```bash
# Configure the CLI
stackgen configure

# Create an appstack
stackgen appstack create

# List appstacks
stackgen appstack list

# Generate IaC files
stackgen generate

# Provision infrastructure
stackgen provision

# Detect drift
stackgen drift detect

# Upload policies
stackgen upload

# Manage resources
stackgen resource type

# Manage projects
stackgen project list

# Show version
stackgen version
```

### Configuration

The CLI can be configured using:

1. Environment variables (prefixed with `STACKGEN_`)
2. Configuration file (`~/.stackgen/config.yaml`)
3. Command-line flags

### Environment Variables

- `STACKGEN_URL`: StackGen server URL
- `STACKGEN_GIT_AUTH_TOKEN`: Git authentication token
- `STACKGEN_TEAM` or `PROJECT`: Team/project identifier
- `STACKGEN_TOKEN`: StackGen API token

## Development

### Prerequisites

- Go 1.24.4 or later
- Git
- Make

### Building

```bash
make build
```

### Testing

```bash
make test
```

## Contributing

1. Create a feature branch
2. Make your changes
3. Write tests
4. Submit a pull request
